/*
 * TagEntryDisplay.cpp
 *
 *  Created on: 03.11.2009
 *      Author: stefan.detter
 */

#include "TagEntry.h"

#include <QFont>
#include <QPixmap>
#include <QBrush>

#include <QrfeGlobal>

TreeItem::TYPE TagEntry::itemType() const
{
	return TAG;
}

QVariant TagEntry::data(int column, int role) const
{
	switch(role)
	{
		case Qt::TextAlignmentRole:
		{
			if((TreeItem::COLUMN_INDEX)column == COL_ID)
				return int(Qt::AlignLeft | Qt::AlignVCenter);
			else
				return int(Qt::AlignHCenter | Qt::AlignVCenter);

			break;
		}

		case Qt::DisplayRole:
		{
			switch((TreeItem::COLUMN_INDEX)column)
			{
			case COL_ID:
                return visualTagId();
			case COL_TagType:
				return m_tag.tagType();
			case COL_ReadRate:
				return QString("%1").arg(m_readRate, 1, 'g', 5);
			case COL_ReadCount:
				return m_readCount;
			case COL_State:
				if(m_triggered)
					return m_triggerSource;
			default:
				break;
			}
			break;
		}

		case Qt::FontRole:
		{
			QFont f = m_treeBoxFont;

			if((TreeItem::COLUMN_INDEX)column == COL_ID)
			{
				f.setBold(true);
#ifdef Q_OS_WIN
				f.setPointSize(10);
#else
				f.setPointSize(12);
#endif
			}
			else
			{
				if((TreeItem::COLUMN_INDEX)column == COL_State)
				{
					f.setBold(true);
				}
#ifdef Q_OS_WIN
#else
				f.setPointSize(11);
#endif
			}

			return f;

			break;
		}

		case Qt::DecorationRole:
		{
			if((TreeItem::COLUMN_INDEX)column == COL_ID)
			{
// TODO!!
//				if(m_tag.tagType() == QrfeGlobal::TAG_RFE_AUR_GEN_1_3)
//					return QPixmap(":/icons/activeTag_icon");

				return QPixmap(":/icons/passiveTag_icon");
			}
			if((TreeItem::COLUMN_INDEX)column == COL_State && m_triggered)
			{
				return QPixmap(":/icons/button");
			}

			break;
		}

		case Qt::ForegroundRole:
		{
			Qt::GlobalColor color = Qt::black;
			switch(m_state)
			{
			case STATE_ACTIVE:
			case STATE_OUTOFRANGE:
				color = Qt::black;
				break;
			case STATE_INACTIVE:
				color = Qt::darkGray;
				break;
			}
			return QBrush(color);
			break;
		}

		case Qt::BackgroundRole:
		{
			if(m_triggered){
				QLinearGradient lg(0, 0, 0, 20 );
				lg.setColorAt(0, Qt::white);
				lg.setColorAt(0.3, QColor(0xFF, 0xB0, 0x14));
				lg.setColorAt(0.7, QColor(0xFF, 0xB0, 0x14));
				lg.setColorAt(1, Qt::white);
				return QBrush(lg);
			}

			Qt::GlobalColor color = Qt::white;
			switch(m_state)
			{
			case STATE_ACTIVE:
			case STATE_INACTIVE:
				//color = Qt::white;
				return QVariant();
				break;
			case STATE_OUTOFRANGE:
				color = Qt::lightGray;
				break;
			}

			return QBrush(color);
			break;
		}
	}

	return QVariant();
}


QVariant TagEntry::information (int row, int column, int role) const
{
	switch(role)
	{
		case Qt::DecorationRole:
		{
			if(column == 0)
			{
				switch(row)
				{
				case TAG_ROW_HEADER:
					return QPixmap(":/icons/passiveTag_icon");
				}
			}
			break;
		}
	}

	return TreeItem::information(row, column, role);
}

void TagEntry::prepareInformation ( )
{
	int size = 10;

	m_informationHeader.clear();
	m_informationHeader << TAG_ROW_HEADER;

	m_informationSubHeader.clear();
	m_informationSubHeader << TAG_ROW_COMMON << TAG_ROW_CURRENTREAD;

	m_informationKeys.resize(size);
	m_informationKeys[TAG_ROW_HEADER] 			= "Tag";
	m_informationKeys[TAG_ROW_COMMON] 			= "Common";
	m_informationKeys[TAG_ROW_TagId] 			= "Tag Id";
	m_informationKeys[TAG_ROW_TagType] 			= "Tag Type";
	m_informationKeys[TAG_ROW_CURRENTREAD] 		= "Current Read";
	m_informationKeys[TAG_ROW_State] 			= "State";
	m_informationKeys[TAG_ROW_TimeStamp] 		= "Time Stamp";
	m_informationKeys[TAG_ROW_ReadCount] 		= "Read Count";
	m_informationKeys[TAG_ROW_ReadRate] 		= "Read Rate";
	m_informationKeys[TAG_ROW_MaxReadRate] 		= "Max. Read Rate";

	m_informationValues.resize(size);
	m_informationValues[TAG_ROW_TagId] 			= QrfeGlobal::getWrappedString(m_tag.tagId(), 30);
	m_informationValues[TAG_ROW_TagType] 		= m_tag.tagType();
	updateInformation ( );
}

void TagEntry::updateInformation ( )
{
	QVector<QString> temp(m_informationValues);

	m_informationValues[TAG_ROW_State] 			= stateToString(m_state);
	m_informationValues[TAG_ROW_TimeStamp] 		= m_timeStamp.toString(Qt::ISODate);
	m_informationValues[TAG_ROW_ReadCount] 		= QString::number(m_readCount);
	m_informationValues[TAG_ROW_ReadRate] 		= QString("%1").arg(m_readRate, 1, 'g', 5);
	m_informationValues[TAG_ROW_MaxReadRate] 	= QString("%1").arg(m_maxReadRate, 1, 'g', 5);

	if(temp != m_informationValues)
		emit informationChanged(TAG_ROW_State, TAG_ROW_MaxReadRate);
}


QString TagEntry::stateToString(TagState state)
{
	switch(state)
	{
	case STATE_ACTIVE:
		return "Active";
	case STATE_INACTIVE:
		return "Inactive";
	case STATE_OUTOFRANGE:
		return "Out Of Range";
	default:
		return QString();
	}
}

